// ################################################################################
//
//  Light Sensor Test vB0
//
//  Released:  09/01/2025
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.1.0

    This code was writtent to confirm the function of the front facing light sensor,
    made from two light sensitive resistors. It reports the analogue values read to
    the IDE serial monitor.
    
    IMPORTANT - Espressif changed the way ESP-NOW works from v3.0, which broke the original
    code and caused compiler errors. This version has been modified to work with v3.0+.
    Enjoy!
*/
// Declare libraries

#define Released "09/01/2025"

// define constants
#define LDR0_Pin 39                  // GPIO for left-hand sensor
#define LDR1_Pin 34                  // GPIO for right-hand sensor

// Declare and initialise general global variables
int16_t LDR0_Val;                    // previous state of SW0
int16_t LDR1_Val;                    // state read by the code

// --------------------------------------------------------------------------------

void setup() {
  // Setup basic functions
  pinMode(LDR0_Pin,INPUT);
  pinMode(LDR1_Pin,INPUT);

  Serial.begin(115200); // use this baud rate
  Serial.println("Omni-Bot");
  Serial.println("Light Sensor Test");
  Serial.println("");
  delay(20);
}

// --------------------------------------------------------------------------------

void loop() {
  // This main loop runs continuously, on a 20ms cycle.
  // After taking a reading we switch over the ADC mux and allow it time to settle
  int16_t zTempVal; 
  LDR0_Val = analogRead(LDR0_Pin); zTempVal = analogRead(LDR1_Pin);
  delay (10);
  LDR1_Val = analogRead(LDR1_Pin); zTempVal = analogRead(LDR0_Pin);
  Serial.println("Left LDR:" + String(LDR0_Val) + "\tRight LDR:" + String(LDR1_Val));
  delay (10);
}

// --------------------------------------------------------------------------------
